/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetWoodElf;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.item.LOTREntityArrowAvari;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemBow;
import lotr.common.item.LOTRItemMug;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.biome.LOTRBiomeGenRhunForest;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityAvariElf
extends LOTREntityElf {
    public LOTREntityAvariElf(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
        this.addTargetTasks(true, LOTREntityAINearestAttackableTargetWoodElf.class);
    }

    @Override
    protected LOTRFoods getElfDrinks() {
        return LOTRFoods.WOOD_ELF_DRINK;
    }

    @Override
    public void func_70690_d(PotionEffect effect) {
        if (effect.func_76456_a() == LOTRPotions.blood.field_76415_H) {
            return;
        }
        super.func_70690_d(effect);
    }

    @Override
    protected EntityAIBase createElfMeleeAttackAI() {
        return this.createElfRangedAttackAI();
    }

    @Override
    protected EntityAIBase createElfRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.25, 30, 50, 16.0f);
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getSindarinName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.bowAvariElf));
        this.npcItemsInv.setMeleeWeapon(this.npcItemsInv.getRangedWeapon());
        this.npcItemsInv.setIdleItem(null);
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.AVARI;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killAvariElf;
    }

    @Override
    public float getAlignmentBonus() {
        return 1.0f;
    }

    @Override
    protected void dropElfItems(boolean flag, int i) {
        super.dropElfItems(flag, i);
        if (flag) {
            int dropChance = 20 - i * 4;
            if (this.field_70146_Z.nextInt(dropChance = Math.max(dropChance, 1)) == 0) {
                ItemStack elfDrink = new ItemStack(LOTRMod.mugRedWine);
                elfDrink.func_77964_b(1 + this.field_70146_Z.nextInt(3));
                LOTRItemMug.setVessel(elfDrink, LOTRFoods.ELF_DRINK.getRandomVessel(this.field_70146_Z), true);
                this.func_70099_a(elfDrink, 0.0f);
            }
        }
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.dropChestContents(LOTRChestContents.LOTRChestContents2.AVARI_ELF_HOUSE, 1, 1 + i);
        }
    }

    @Override
    public boolean canElfSpawnHere() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenRhunForest) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "avariElf/elf/hired";
            }
            if (LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= LOTREntityAvariElf.getWoodlandTrustLevel()) {
                return "avariElf/elf/friendly";
            }
            return "avariElf/elf/neutral";
        }
        return "avariElf/elf/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.AVARI_ELF.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.AVARI_ELF;
    }

    public static float getWoodlandTrustLevel() {
        return LOTRFaction.AVARI.getFirstRank().alignment;
    }

    protected float getFireArrowChance() {
        return 0.06666667f;
    }

    @Override
    protected void npcArrowAttack(EntityLivingBase target, float f) {
        LOTREntityArrowAvari arrow;
        ItemStack heldItem = this.func_70694_bm();
        float str = 1.3f + this.func_70032_d((Entity)target) / 80.0f;
        float accuracy = (float)this.func_110148_a(npcRangedAccuracy).func_111126_e();
        float poisonChance = this.getFireArrowChance();
        LOTREntityArrowAvari lOTREntityArrowAvari = arrow = this.field_70146_Z.nextFloat() < poisonChance ? new LOTREntityArrowAvari(this.field_70170_p, (EntityLivingBase)this, target, str, accuracy) : new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, str *= LOTRItemBow.getLaunchSpeedFactor(heldItem), accuracy);
        if (heldItem != null) {
            LOTRItemBow.applyBowModifiers(arrow, heldItem);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }
}

